import os, _thread, time

SERVICES = {}

def service(name):
    def decorator(func):
        SERVICES[name] = func
        return func
    return decorator

def start_service(name):
    if name in SERVICES:
        _thread.start_new_thread(SERVICES[name], ())
        print(f"Service {name} started")
    else:
        print("No such service:", name)

def stop_service(name):
    print("Service stopping not implemented (stub)")

def list_services():
    for name in SERVICES: print(name)

# Example usage:
# @service("dummy")
# def dummy_service(): while True: time.sleep(1)
